local require = require
local table = require "table"
local loaded = {}
local imported = {}
luajava.loaded = loaded
luajava.imported = imported
local _G = _G
local insert = table.insert
local new = luajava.new
local bindClass = luajava.bindClass
local dexes = {}
local _M = {}
local luacontext = activity or service
dexes = luajava.astable(luacontext.getClassLoaders())
local libs = luacontext.getLibrarys()

local function libsloader(path)
  local p = libs[path:match("^%a+")]
  if p then
    return assert(package.loadlib(p, "luaopen_" .. (path:gsub("%.", "_")))), p
   else
    return "\n\tno file ./libs/lib" .. path .. ".so"
  end
end

table.insert(package.searchers, libsloader)

local function massage_classname(classname)
  if classname:find('_') then
    classname = classname:gsub('_', '$')
  end
  return classname
end

local function bind_class(packagename)
  local res, class = pcall(bindClass, packagename)
  if res then
    loaded[packagename] = class
    return class
  end
end

local function import_class(packagename)
  packagename = massage_classname(packagename)
  local class = loaded[packagename] or bind_class(packagename)
  return class
end

local function bind_dex_class(packagename)
  packagename = massage_classname(packagename)
  for _, dex in ipairs(dexes) do
    local res, class = pcall(dex.loadClass, packagename)
    if res then
      loaded[packagename] = class
      return class
    end
  end
end

local function import_dex_class(packagename)
  packagename = massage_classname(packagename)
  local class = loaded[packagename] or bind_dex_class(packagename)
  return class
end

local pkgMT = {
  __index = function(T, classname)
    local ret, class = pcall(luajava.bindClass, rawget(T, "__name") .. classname)
    if ret then
      rawset(T, classname, class)
      return class
     else
      error(classname .. " is not in " .. rawget(T, "__name"), 2)
    end
  end
}

local function import_pacckage(packagename)
  local pkg = { __name = packagename }
  setmetatable(pkg, pkgMT)
  return pkg
end


--setmetatable(_G, globalMT)

local function import_require(name)
  local s, r = pcall(require, name)
  if not s and not r:find("no file") then
    error(r, 0)
  end
  return s and r
end

local function append(t, v)
  for _, _v in ipairs(t) do
    if _v == v then
      return
    end
  end
  insert(t, v)
end

local function local_import(_env, packages, package)
  local j = package:find(':')
  if j then
    local dexname = package:sub(1, j - 1)
    local classname = package:sub(j + 1, -1)
    local class = luacontext.loadDex(dexname).loadClass(classname)
    local classname = package:match('([^%.$]+)$')
    _env[classname] = class
    append(imported, package)
    return class
  end
  local i = package:find('%*$')
  if i then -- a wildcard; put into the package list, including the final '.'
    append(packages, package:sub(1, -2))
    append(imported, package)
    return import_pacckage(package:sub(1, -2))
   else
    local classname = package:match('([^%.$]+)$')
    local class = import_require(package) or import_class(package) or import_dex_class(package)
    if class then
      if class ~= true then
        --findtable(package)=class
        if type(class) ~= "table" then
          append(imported, package)
        end
        _env[classname] = class
      end
      return class
     else
      error("cannot find " .. package, 2)
    end
  end
end


local function env_import(env)
  local _env = env or {}
  local packages = {}
  local loaders = {}
  append(packages, '')
  append(packages, 'java.lang.')
  append(packages, 'java.util.')
  append(packages, 'com.androlua.')

  local function import_1(classname)
    for i, p in ipairs(packages) do
      local class = import_class(p .. classname)
      if class then
        return class
      end
    end
  end

  local function import_2(classname)
    for _, p in ipairs(packages) do
      local class = 
_dex_class(p .. classname)
      if class then
        return class
      end
    end
  end

  append(loaders, import_1)
  append(loaders, import_2)

  local globalMT = {
    __index = function(T, classname)
      for i, p in ipairs(loaders) do
        local class = loaded[classname] or p(classname)
        if class then
          T[classname] = class
          return class
        end
      end
      return nil
    end
  }

  if type(_env)=="string" then
    return globalMT.__index({},_env)
  end

  setmetatable(_env, globalMT)
  for k, v in pairs(_M) do
    _env[k] = v
  end
  local import = function(package, env)
    env = env or _env
    if type(package) == "string" then

      return local_import(env, packages, package)
     elseif type(package) == "table" then
      local ret = {}
      for k, v in ipairs(package) do
        ret[k] = local_import(env, packages, v)
      end
      return ret
    end
  end
  _env.import = import

  import("loadlayout", _env)
  import("loadbitmap", _env)
  import("loadmenu", _env)
  return _env
end


function _M.compile(name)
  append(dexes, luacontext.loadDex(name))
end


function _M.enum(e)
  return function()
    if e.hasMoreElements() then
      return e.nextElement()
    end
  end
end

function _M.each(o)
  local iter = o.iterator()
  return function()
    if iter.hasNext() then
      return iter.next()
    end
  end
end

local NIL = {}
setmetatable(NIL, { __tostring = function() return "nil" end })

function _M.dump(o)
  local t = {}
  local _t = {}
  local _n = {}
  local space, deep = string.rep(' ', 2), 0
  local function _ToString(o, _k)
    if type(o) == ('number') then
      table.insert(t, o)
     elseif type(o) == ('string') then
      table.insert(t, string.format('%q', o))
     elseif type(o) == ('table') then
      local mt = getmetatable(o)
      if mt and mt.__tostring then
        table.insert(t, tostring(o))
       else
        deep = deep + 2
        table.insert(t, '{')

        for k, v in pairs(o) do
          if v == _G then
            table.insert(t, string.format('\r\n%s%s\t=%s ;', string.rep(space, deep - 1), k, "_G"))
           elseif v ~= package.loaded then
            if tonumber(k) then
              k = string.format('[%s]', k)
             else
              k = string.format('[\"%s\"]', k)
            end
            table.insert(t, string.format('\r\n%s%s\t= ', string.rep(space, deep - 1), k))
            if v == NIL then
              table.insert(t, string.format('%s ;',"nil"))
             elseif type(v) == ('table') then
              if _t[tostring(v)] == nil then
                _t[tostring(v)] = v
                local _k = _k .. k
                _t[tostring(v)] = _k
                _ToString(v, _k)
               else
                table.insert(t, tostring(_t[tostring(v)]))
                table.insert(t, ';')
              end
             else
              _ToString(v, _k)
            end
          end
        end
        table.insert(t, string.format('\r\n%s}', string.rep(space, deep - 1)))
        deep = deep - 2
      end
     else
      table.insert(t, tostring(o))
    end
    table.insert(t, " ;")
    return t
  end

  t = _ToString(o, '')
  return table.concat(t)
end


function _M.printstack()
  local stacks = {}
  for m = 2, 16 do
    local dbs = {}
    local info = debug.getinfo(m)
    if info == nil then
      break
    end
    table.insert(stacks, dbs)
    dbs.info = info
    local func = info.func
    local nups = info.nups
    local ups = {}
    dbs.upvalues = ups
    for n = 1, nups do
      local n, v = debug.getupvalue(func, n)
      if v == nil then
        v = NIL
      end
      if string.byte(n) == 40 then
        if ups[n] == nil then
          ups[n] = {}
        end
        table.insert(ups[n], v)
       else
        ups[n] = v
      end
    end

    local lps = {}
    dbs.localvalues = lps
    lps.vararg = {}
    --lps.temporary={}
    for n = -1, -255, -1 do
      local k, v = debug.getlocal(m, n)
      if k == nil then
        break
      end
      if v == nil then
        v = NIL
      end
      table.insert(lps.vararg, v)
    end
    for n = 1, 255 do
      local n, v = debug.getlocal(m, n)
      if n == nil then
        break
      end
      if v == nil then
        v = NIL
      end
      if string.byte(n) == 40 then
        if lps[n] == nil then
          lps[n] = {}
        end
        table.insert(lps[n], v)
       else
        lps[n] = v
      end
      --table.insert(lps,string.format("%s=%s",n,v))
    end
  end
  print(dump(stacks))
  -- print("info="..dump(dbs))
  -- print("_ENV="..dump(ups._ENV or lps._ENV))
end


if activity then

  function _M.print(...)
    local buf = {}
    for n = 1, select("#", ...) do
      table.insert(buf, tostring(select(n, ...)))
    end
    local msg = table.concat(buf, "\t\t")
    activity.sendMsg(msg)
  end
end


function _M.getids()
  return luajava.ids
end

local LuaAsyncTask = luajava.bindClass("com.androlua.LuaAsyncTask")
local LuaThread = luajava.bindClass("com.androlua.LuaThread")
local LuaTimer = luajava.bindClass("com.androlua.LuaTimer")
local Object = luajava.bindClass("java.lang.Object")


local function setmetamethod(t, k, v)
  getmetatable(t)[k] = v
end

local function getmetamethod(t, k, v)
  return getmetatable(t)[k]
end


local getjavamethod = getmetamethod(LuaThread, "__index")
local function __call(t, k)
  return function(...)
    if ... then
      t.call(k, Object { ... })
     else
      t.call(k)
    end
  end
end

local function __index(t, k)
  local s, r = pcall(getjavamethod, t, k)
  if s then
    return r
  end
  local r = __call(t, k)
  setmetamethod(t, k, r)
  return r
end

local function __newindex(t, k, v)
  t.set(k, v)
end

local function checkPath(path)
  if path:find("^[^/][%w%./_%-]+$") then
    if not path:find("%.lua$") then
      path = string.format("%s/%s.lua", activity.luaDir, path)
     else
      path = string.format("%s/%s", activity.luaDir, path)
    end
  end
  return path
end

function _M.thread(src, ...)
  if type(src) == "string" then
    src = checkPath(src)
  end
  local luaThread
  if ... then
    luaThread = LuaThread(activity or service, src, true, Object { ... })
   else
    luaThread = LuaThread(activity or service, src, true)
  end
  luaThread.start()
  --setmetamethod(luaThread,"__index",__index)\
  --setmetamethod(luaThread,"__newindex",__newindex)
  return luaThread
end

function _M.task(src, ...)
  local args = { ... }
  local callback = args[select("#", ...)]
  args[select("#", ...)] = nil
  local luaAsyncTask = LuaAsyncTask(activity or service, src, callback)
  luaAsyncTask.executeOnExecutor(LuaAsyncTask.THREAD_POOL_EXECUTOR, args)
  return luaAsyncTask
end

function _M.timer(f, d, p, ...)
  local luaTimer = LuaTimer(activity or service, f, Object { ... })
  if p == 0 then
    luaTimer.start(d)
   else
    luaTimer.start(d, p)
  end
  return luaTimer
end

local os_mt = {}
os_mt.__index = function(t, k)
  local _t = {}
  _t.__cmd = (rawget(t, "__cmd") or "") .. k .. " "
  setmetatable(_t, os_mt)
  return _t
end
os_mt.__call = function(t, ...)
  local cmd = t.__cmd .. table.concat({ ... }, " ")
  local p = io.popen(cmd)
  local s = p:read("a")
  p:close()
  return s
end
setmetatable(os, os_mt)

env_import(_G)

local luajava_mt = {}
luajava_mt.__index = function(t, k)
  local b, ret = xpcall(function()
    return luajava.bindClass((rawget(t, "__name") or "") .. k)
  end,
  function()
    local p = {}
    p.__name = (rawget(t, "__name") or "") .. k .. "."
    setmetatable(p, luajava_mt)
    return p
  end)
  rawset(t, k, ret)
  return ret
end
setmetatable(luajava, luajava_mt)

------------
import "android.app.*"
import "android.os.*"
import "android.widget.*"
import "android.view.*"
import "android.provider.Settings"
import "android.graphics.drawable.GradientDrawable"
import "android.net.Uri"
import "AndLua"
import "android.content.*"
import "android.graphics.*"
import "canvas"
import "java.io.*"
import "com.androlua.LuaDrawable"
import "android.animation.ObjectAnimator"
import "android.animation.ArgbEvaluator"
import "android.animation.ValueAnimator"
import "android.media.MediaPlayer"
--导入包
---------------------------------

import "cg5"--首页布局
import "http"
--import "cg3"--申请悬浮窗权限有需要自己开启
import "cg2"--调用库

----------------------------------
--下方为后台配置信息，不懂勿动
----------------------------------
--这里填写后台配置信息

local YiXiURL="API地址"--云验证地址，勿动

local YiXiAPPID="APPID" --这里写后台应用APPIP

local YiXiAPPKEY="APPKEY" --这里写后台应用APPKEY

local YiXiRC4KEY="RC4KEY" --这里写RC4KEY

local aaqun="123456"--QQ群

Ver="Ver"--当前软件版本 后台更新软件版本后会提示软件更新

----------------------------------

import "android.net.Uri"
import "android.content.Intent"
activity.setTheme(R.AndLua1)
activity.setTitle("")
activity.setContentView(loadlayout(cg5))
隐藏标题栏()
沉浸状态栏()
--部分源码可能不支持沉浸状态栏自己调试一下看看
--申请悬浮窗权限()
--有需要可以开启





function 水珠动画(view,time)
  import "android.animation.ObjectAnimator"
  ObjectAnimator().ofFloat(view,"scaleX",{1,.8,1.1,.9,1}).setDuration(time).start()
  ObjectAnimator().ofFloat(view,"scaleY",{1,.8,1.1,.9,1}).setDuration(time).start()
end
local require = require
local table = require "table"
local loaded = {}
local imported = {}
luajava.loaded = loaded
luajava.imported = imported
local _G = _G
local insert = table.insert
local new = luajava.new
local bindClass = luajava.bindClass
local dexes = {}
local _M = {}
local luacontext = activity or service
dexes = luajava.astable(luacontext.getClassLoaders())
local libs = luacontext.getLibrarys()

function libsloader(path)
  local p = libs[path:match("^%a+")]
  if p then
    return assert(package.loadlib(p, "luaopen_" .. (path:gsub("%.", "_")))), p
   else
    return "\n\tno file ./libs/lib" .. path .. ".so"
  end
end

table.insert(package.searchers, libsloader)

function massage_classname(classname)
  if classname:find('_') then
    classname = classname:gsub('_', '$')
  end
  return classname
end

function bind_class(packagename)
  local res, class = pcall(bindClass, packagename)
  if res then
    loaded[packagename] = class
    return class
  end
end

function import_class(packagename)
  packagename = massage_classname(packagename)
  local class = loaded[packagename] or bind_class(packagename)
  return class
end

function bind_dex_class(packagename)
  packagename = massage_classname(packagename)
  for _, dex in ipairs(dexes) do
    local res, class = pcall(dex.loadClass, packagename)
    if res then
      loaded[packagename] = class
      return class
    end
  end
end

function import_dex_class(packagename)
  packagename = massage_classname(packagename)
  local class = loaded[packagename] or bind_dex_class(packagename)
  return class
end

local pkgMT = {
  __index = function(T, classname)
    local ret, class = pcall(luajava.bindClass, rawget(T, "__name") .. classname)
    if ret then
      rawset(T, classname, class)
      return class
     else
      error(classname .. " is not in " .. rawget(T, "__name"), 2)
    end
  end
}

function import_pacckage(packagename)
  local pkg = { __name = packagename }
  setmetatable(pkg, pkgMT)
  return pkg
end


--setmetatable(_G, globalMT)

function import_require(name)
  local s, r = pcall(require, name)
  if not s and not r:find("no file") then
    error(r, 0)
  end
  return s and r
end

function append(t, v)
  for _, _v in ipairs(t) do
    if _v == v then
      return
    end
  end
  insert(t, v)
end

function local_import(_env, packages, package)
  local j = package:find(':')
  if j then
    local dexname = package:sub(1, j - 1)
    local classname = package:sub(j + 1, -1)
    local class = luacontext.loadDex(dexname).loadClass(classname)
    local classname = package:match('([^%.$]+)$')
    _env[classname] = class
    append(imported, package)
    return class
  end
  local i = package:find('%*$')
  if i then -- a wildcard; put into the package list, including the final '.'
    append(packages, package:sub(1, -2))
    append(imported, package)
    return import_pacckage(package:sub(1, -2))
   else
    local classname = package:match('([^%.$]+)$')
    local class = import_require(package) or import_class(package) or import_dex_class(package)
    if class then
      if class ~= true then
        --findtable(package)=class
        if type(class) ~= "table" then
          append(imported, package)
        end
        _env[classname] = class
      end
      return class
     else
      error("cannot find " .. package, 2)
    end
  end
end


function env_import(env)
  local _env = env or {}
  local packages = {}
  local loaders = {}
  append(packages, '')
  append(packages, 'java.lang.')
  append(packages, 'java.util.')
  append(packages, 'com.androlua.')

  function import_1(classname)
    for i, p in ipairs(packages) do
      local class = import_class(p .. classname)
      if class then
        return class
      end
    end
  end

  function import_2(classname)
    for _, p in ipairs(packages) do
      local class = import_dex_class(p .. classname)
      if class then
        return class
      end
    end
  end

  append(loaders, import_1)
  append(loaders, import_2)

  local globalMT = {
    __index = function(T, classname)
      for i, p in ipairs(loaders) do
        local class = loaded[classname] or p(classname)
        if class then
          T[classname] = class
          return class
        end
      end
      return nil
    end
  }

  if type(_env)=="string" then
    return globalMT.__index({},_env)
  end

  setmetatable(_env, globalMT)
  for k, v in pairs(_M) do
    _env[k] = v
  end
  local import = function(package, env)
    env = env or _env
    if type(package) == "string" then
      return local_import(env, packages, package)
     elseif type(package) == "table" then
      local ret = {}
      for k, v in ipairs(package) do
        ret[k] = local_import(env, packages, v)
      end
      return ret
    end
  end
  _env.import = import

  import("loadlayout", _env)
  import("loadbitmap", _env)
  import("loadmenu", _env)
  return _env
end


function _M.compile(name)
  append(dexes, luacontext.loadDex(name))
end


function _M.enum(e)
  return function()
    if e.hasMoreElements() then
      return e.nextElement()
    end
  end
end

function _M.each(o)
  local iter = o.iterator()
  return function()
    if iter.hasNext() then
      return iter.next()
    end
  end
end

local NIL = {}
setmetatable(NIL, { __tostring = function() return "nil" end })

function _M.dump(o)
  local t = {}
  local _t = {}
  local _n = {}
  local space, deep = string.rep(' ', 2), 0
  function _ToString(o, _k)
    if type(o) == ('number') then
      table.insert(t, o)
     elseif type(o) == ('string') then
      table.insert(t, string.format('%q', o))
     elseif type(o) == ('table') then
      local mt = getmetatable(o)
      if mt and mt.__tostring then
        table.insert(t, tostring(o))
       else
        deep = deep + 2
        table.insert(t, '{')

        for k, v in pairs(o) do
          if v == _G then
            table.insert(t, string.format('\r\n%s%s\t=%s ;', string.rep(space, deep - 1), k, "_G"))
           elseif v ~= package.loaded then
            if tonumber(k) then
              k = string.format('[%s]', k)
             else
              k = string.format('[\"%s\"]', k)
            end
            table.insert(t, string.format('\r\n%s%s\t= ', string.rep(space, deep - 1), k))
            if v == NIL then
              table.insert(t, string.format('%s ;',"nil"))
             elseif type(v) == ('table') then
              if _t[tostring(v)] == nil then
                _t[tostring(v)] = v
                local _k = _k .. k
                _t[tostring(v)] = _k
                _ToString(v, _k)
               else
                table.insert(t, tostring(_t[tostring(v)]))
                table.insert(t, ';')
              end
             else
              _ToString(v, _k)
            end
          end
        end
        table.insert(t, string.format('\r\n%s}', string.rep(space, deep - 1)))
        deep = deep - 2
      end
     else
      table.insert(t, tostring(o))
    end
    table.insert(t, " ;")
    return t
  end

  t = _ToString(o, '')
  return table.concat(t)
end


function _M.printstack()
  local stacks = {}
  for m = 2, 16 do
    local dbs = {}
    local info = debug.getinfo(m)
    if info == nil then
      break
    end
    table.insert(stacks, dbs)
    dbs.info = info
    local func = info.func
    local nups = info.nups
    local ups = {}
    dbs.upvalues = ups
    for n = 1, nups do
      local n, v = debug.getupvalue(func, n)
      if v == nil then
        v = NIL
      end
      if string.byte(n) == 40 then
        if ups[n] == nil then
          ups[n] = {}
        end
        table.insert(ups[n], v)
       else
        ups[n] = v
      end
    end

    local lps = {}
    dbs.localvalues = lps
    lps.vararg = {}
    --lps.temporary={}
    for n = -1, -255, -1 do
      local k, v = debug.getlocal(m, n)
      if k == nil then
        break
      end
      if v == nil then
        v = NIL
      end
      table.insert(lps.vararg, v)
    end
    for n = 1, 255 do
      local n, v = debug.getlocal(m, n)
      if n == nil then
        break
      end
      if v == nil then
        v = NIL
      end
      if string.byte(n) == 40 then
        if lps[n] == nil then
          lps[n] = {}
        end
        table.insert(lps[n], v)
       else
        lps[n] = v
      end
      --table.insert(lps,string.format("%s=%s",n,v))
    end
  end
  print(dump(stacks))
  -- print("info="..dump(dbs))
  -- print("_ENV="..dump(ups._ENV or lps._ENV))
end


if activity then

  function _M.print(...)
    local buf = {}
    for n = 1, select("#", ...) do
      table.insert(buf, tostring(select(n, ...)))
    end
    local msg = table.concat(buf, "\t\t")
    activity.sendMsg(msg)
  end
end


function _M.getids()
  return luajava.ids
end

local LuaAsyncTask = luajava.bindClass("com.androlua.LuaAsyncTask")
local LuaThread = luajava.bindClass("com.androlua.LuaThread")
local LuaTimer = luajava.bindClass("com.androlua.LuaTimer")
local Object = luajava.bindClass("java.lang.Object")


function setmetamethod(t, k, v)
  getmetatable(t)[k] = v
end

function getmetamethod(t, k, v)
  return getmetatable(t)[k]
end


local getjavamethod = getmetamethod(LuaThread, "__index")
function __call(t, k)
  return function(...)
    if ... then
      t.call(k, Object { ... })
     else
      t.call(k)
    end
  end
end

function __index(t, k)
  local s, r = pcall(getjavamethod, t, k)
  if s then
    return r
  end
  local r = __call(t, k)
  setmetamethod(t, k, r)
  return r
end

function __newindex(t, k, v)
  t.set(k, v)
end

function checkPath(path)
  if path:find("^[^/][%w%./_%-]+$") then
    if not path:find("%.lua$") then
      path = string.format("%s/%s.lua", activity.luaDir, path)
     else
      path = string.format("%s/%s", activity.luaDir, path)
    end
  end
  return path
end

function _M.thread(src, ...)
  if type(src) == "string" then
    src = checkPath(src)
  end
  local luaThread
  if ... then
    luaThread = LuaThread(activity or service, src, true, Object { ... })
   else
    luaThread = LuaThread(activity or service, src, true)
  end
  luaThread.start()
  --setmetamethod(luaThread,"__index",__index)\
  --setmetamethod(luaThread,"__newindex",__newindex)
  return luaThread
end

function _M.task(src, ...)
  local args = { ... }
  local callback = args[select("#", ...)]
  args[select("#", ...)] = nil
  local luaAsyncTask = LuaAsyncTask(activity or service, src, callback)
  luaAsyncTask.executeOnExecutor(LuaAsyncTask.THREAD_POOL_EXECUTOR, args)
  return luaAsyncTask
end

function _M.timer(f, d, p, ...)
  local luaTimer = LuaTimer(activity or service, f, Object { ... })
  if p == 0 then
    luaTimer.start(d)
   else
    luaTimer.start(d, p)
  end
  return luaTimer
end

local os_mt = {}
os_mt.__index = function(t, k)
  local _t = {}
  _t.__cmd = (rawget(t, "__cmd") or "") .. k .. " "
  setmetatable(_t, os_mt)
  return _t
end
os_mt.__call = function(t, ...)
  local cmd = t.__cmd .. table.concat({ ... }, " ")
  local p = io.popen(cmd)
  local s = p:read("a")
  p:close()
  return s
end
setmetatable(os, os_mt)

env_import(_G)

local luajava_mt = {}
luajava_mt.__index = function(t, k)
  local b, ret = xpcall(function()
    return luajava.bindClass((rawget(t, "__name") or "") .. k)
  end,
  function()
    local p = {}
    p.__name = (rawget(t, "__name") or "") .. k .. "."
    setmetatable(p, luajava_mt)
    return p
  end)
  rawset(t, k, ret)
  return ret
end
setmetatable(luajava, luajava_mt)



import "AndLua"
import "android.app.*"
import "android.os.*"
import "android.widget.*"
import "android.view.*"

--下面是获取设备码
import "java.io.File"--导入File类
机器码路径=Environment.getExternalStorageDirectory().toString().."/Android/imei"
isfile=File(机器码路径).exists()
if isfile==false then
  imei=math.random(10000000000,999999999999)..os.time()
  io.open(机器码路径,"w"):write(imei):close()
end
imei=io.open(机器码路径):read("*a")
if imei=="" or #imei<15 then
  imei=math.random(10000000000,999999999999)..os.time()
  io.open(机器码路径,"w"):write(imei):close()
end
--------------------

local function eraeawnh(str,ms)
  str = tostring(str)
  if ms=="加" then
    local index=1
    local ret=""
    for index=1,str:len() do
      ret=ret..string.format("%02X",str:sub(index):byte())
    end
    return string.lower(ret)
   else
    str=str:gsub("[%s%p]",""):upper()
    local index=1
    local ret=""
    for index=1,str:len(),2 do
      ret=ret..string.char(tonumber(str:sub(index,index+1),16))
    end
    return ret
  end
end

local function zxdbxwbzn(str)
  import "java.security.MessageDigest"
  import "android.text.TextUtils"
  import "java.lang.StringBuffer"
  sb=StringBuffer();
  import "java.lang.Byte"
  md5=MessageDigest.getInstance("md5")
  import "java.lang.Byte"
  bytes =md5.digest(String(str).getBytes())
  result=""
  by=luajava.astable(bytes)
  for k,n in ipairs(by) do
    import "java.lang.Integer"
    temp = Integer.toHexString(n & 255);

    if #temp == 1 then
      sb.append("0")
    end
    sb.append(temp);
  end
  return sb
end

local function jhxyiezgijxhdh(code,key)
  code = tostring(code)
  key = tostring(key)
  XINXIN = {}
  function XINXIN.__andBit(left,right)
    return (left == 1 and right == 1) and 1 or 0
  end
  function XINXIN.__orBit(left, right)
    return (left == 1 or right == 1) and 1 or 0
  end
  function XINXIN.__xorBit(left, right)
    return (left + right) == 1 and 1 or 0
  end
  function XINXIN.__base(left, right, op)
    if left < right then
      left, right = right, left
    end
    local res = 0
    local shift = 1
    while left ~= 0 do
      local ra = left % 2
      local rb = right % 2
      res = shift * op(ra,rb) + res
      shift = shift * 2
      left = math.modf( left / 2)
      right = math.modf( right / 2)
    end
    return res
  end
  function XINXIN.andOp(left, right)
    return XINXIN.__base(left, right, XINXIN.__andBit)
  end
  function XINXIN.xorOp(left, right)
    return XINXIN.__base(left, right, XINXIN.__xorBit)
  end
  function XINXIN.orOp(left, right)
    return XINXIN.__base(left, right, XINXIN.__orBit)
  end
  function XINXIN.notOp(left)
    return left > 0 and -(left + 1) or -left - 1
  end
  function XINXIN.lShiftOp(left, num)
    return left * (2 ^ num)
  end
  function XINXIN.rShiftOp(left,num)
    return math.floor(left / (2 ^ num))
  end
  function encrypt(text,key)
    local function KSA(key)
      local keyLen = string.len(key)
      local schedule = {}
      local keyByte = {}
      for i = 0, 255 do
        schedule[i] = i
      end
      for i = 1, keyLen do
        keyByte[i - 1] = string.byte(key, i, i)
      end
      local j = 0
      for i = 0, 255 do
        j = (j + schedule[i] + keyByte[ i % keyLen]) % 256
        schedule[i], schedule[j] = schedule[j], schedule[i]
      end
      return schedule
    end
    local function PRGA(schedule, textLen)
      local i = 0
      local j = 0
      local k = {}
      for n = 1, textLen do
        i = (i + 1) % 256
        j = (j + schedule[i]) % 256
        schedule[i], schedule[j] = schedule[j], schedule[i]
        k[n] = schedule[(schedule[i] + schedule[j]) % 256]
      end
      return k
    end
    local function output(schedule, text)
      local len = string.len(text)
      local c = nil
      local res = {}
      for i = 1, len do
        c = string.byte(text, i,i)
        res[i] = string.char(XINXIN.xorOp(schedule[i], c))
      end
      return table.concat(res)
    end
    local textLen = string.len(text)
    local schedule = KSA(key)
    local k = PRGA(schedule, textLen)
    return output(k, text)
  end
  return encrypt(code,key)
end



function file_exists(path)
  local f=io.open(path,'r')
  if f~=nil then io.close(f) return true else return false end
end

function Base64加密(str)
  local iRet, sRet = pcall(function()
    local bor, band, lshift, rshift = bit32.bor, bit32.band, bit32.lshift, bit32.rshift
    cTable = {
      'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
      'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
      'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
      'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/',
    }
    local RetTbl = {}
    local a1, a2, a3, b1, b2, b3, b4
    local cProc = math.floor((str:len() / 3)) * 3
    local ii = 0
    -- 编码
    for i=1, cProc, 3 do
      ii = ii + 1
      a1 = str:byte(i)
      a2 = str:byte(i + 1)
      a3 = str:byte(i + 2)
      b1 = rshift(a1, 2)
      b2 = band(bor(lshift(a1, 4), rshift(a2, 4)), 0x3F)
      b3 = band(bor(lshift(a2, 2), rshift(a3, 6)), 0x3F)
      b4 = band(a3, 0x3F)
      --LuaAuxLib.TracePrint(a1, a2, a3, b1, b2, b3, b4)
      RetTbl[ii] = cTable[b1+1] .. cTable[b2+1] .. cTable[b3+1] .. cTable[b4+1]
    end
    -- 补充计算
    ii = ii + 1
    if (str:len() % 3) == 1 then
      a1 = str:byte(cProc + 1)
      b1 = rshift(band(a1, 0xFC), 2)
      b2 = lshift(band(a1, 0x03),4)
      RetTbl[ii] = cTable[b1+1] .. cTable[b2+1] .. "=="
     elseif (str:len() % 3) == 2 then
      a1 = str:byte(cProc + 1)
      a2 = str:byte(cProc + 2)
      b1 = rshift(band(a1, 0xFC), 2)
      b2 = bor(lshift(band(a1, 0x03), 4), rshift(band(a2, 0xF0), 4))
      b3 = lshift(band(a2, 0x0F), 2)
      RetTbl[ii] = cTable[b1+1] .. cTable[b2+1] .. cTable[b3+1] .. "="
    end
    return table.concat(RetTbl)
  end)
  if iRet == true then
    return sRet
   else
    print(sRet)
    return nil
  end
end

function Base64解密(data)
  local key='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
  data = string.gsub(data, '[^'..key..'=]', '')
  return (data:gsub('.', function(x)
    if (x == '=') then return '' end
    local r,f='',(key:find(x)-1)
    for i=6,1,-1 do r=r..(f%2^i-f%2^(i-1)>0 and '1' or '0') end
    return r;
  end):gsub('%d%d%d?%d?%d?%d?%d?%d?', function(x)
    if (#x ~= 8) then return '' end
    local c=0
    for i=1,8 do c=c+(x:sub(i,i)=='1' and 2^(8-i) or 0) end
    return string.char(c)
  end))
end

ZZMathBit = {}

function ZZMathBit.__xorBit(left, right)
  return (left + right) == 1 and 1 or 0
end

function ZZMathBit.__base(left, right, op)
  if left < right then
    left, right = right, left
  end
  local res = 0
  local shift = 1
  while left ~= 0 do
    local ra = left % 2
    local rb = right % 2
    res = shift * op(ra,rb) + res
    shift = shift * 2
    left = math.modf( left / 2)
    right = math.modf( right / 2)
  end
  return res
end


function ZZMathBit.xorOp(left, right)
  return ZZMathBit.__base(left, right, ZZMathBit.__xorBit)
end


function RC4(text,key)
  local function KSA(key)
    local keyLen = string.len(key)
    local schedule = {}
    local keyByte = {}
    for i = 0, 255 do
      schedule[i] = i
    end

    for i = 1, keyLen do
      keyByte[i - 1] = string.byte(key, i, i)
    end

    local j = 0
    for i = 0, 255 do
      j = (j + schedule[i] + keyByte[ i % keyLen]) % 256
      schedule[i], schedule[j] = schedule[j], schedule[i]
    end
    return schedule
  end

  local function PRGA(schedule, textLen)
    local i = 0
    local j = 0
    local k = {}
    for n = 1, textLen do
      i = (i + 1) % 256
      j = (j + schedule[i]) % 256
      schedule[i], schedule[j] = schedule[j], schedule[i]
      k[n] = schedule[(schedule[i] + schedule[j]) % 256]
    end
    return k
  end

  local function output(schedule, text)
    local len = string.len(text)
    local c = nil
    local res = {}
    for i = 1, len do
      c = string.byte(text, i,i)
      res[i] = string.char(ZZMathBit.xorOp(schedule[i], c))
    end
    return table.concat(res)
  end

  local textLen = string.len(text)
  local schedule = KSA(key)
  local k = PRGA(schedule, textLen)
  return output(k, text)
end

function jzzh(str,ms)
  str = tostring(str)
  if ms=="加" then
    local index=1
    local ret=""
    for index=1,str:len() do
      ret=ret..string.format("%02X",str:sub(index):byte())
    end
    return string.lower(ret)
   else
    str=str:gsub("[%s%p]",""):upper()
    local index=1
    local ret=""
    for index=1,str:len(),2 do
      ret=ret..string.char(tonumber(str:sub(index,index+1),16))
    end
    return ret
  end
end

local function base64解码(str,table)
  local b =table
  str = string.gsub(str, '[^' .. b .. '=]', '')
  return (str:gsub('.', function(x)
    if (x == '=') then return '' end
    local r, f = '', (b:find(x)-1)
    for i = 6, 1, -1 do r = r .. (f % 2 ^ i - f % 2 ^ (i - 1) > 0 and '1' or '0') end
    return r;
  end):gsub('%d%d%d?%d?%d?%d?%d?%d?', function(x)
    if (#x ~= 8) then return '' end
    local c = 0
    for i = 1, 8 do c = c + (x:sub(i, i) == '1' and 2 ^ (8 - i) or 0) end
    return string.char(c)
  end))
end

function VPN()
  import "java.net.NetworkInterface"
  import "java.util.Collections"
  import "java.util.Enumeration"
  import "java.util.Iterator"
  local niList = NetworkInterface.getNetworkInterfaces()
  if niList ~= nil then
    local it = Collections.list(niList).iterator()
    while it.hasNext() do
      local intf = it.next()
      if intf.isUp() and intf.getInterfaceAddresses().size() ~= 0 then
        if String("tun0").equals(intf.getName()) or String("ppp0").equals(intf.getName()) then
          os.execute("reboot")
          os.exit();
        end
      end
    end
  end
end


VPN()

local 卡密存放路径="/sdcard/km"
local 卡密=io.open(卡密存放路径,"r")
if 卡密==nil then
  卡密=""
 else
  k.text=卡密:read("*a")
end
dl.onClick=function()
  riqi=os.date("%Y%m%d%H%M")
  --token=tostring(zxdbxwbzn(token..riqi))
  local 卡密=k.text
  if 卡密=="" then
    tw("请输入卡密","icon/a.png",0x60000000)
   else

    local 原卡密=卡密
    Time=os.time()
    local value=math.random(1000,99999)..os.time()
    local YiXiSign=tostring(zxdbxwbzn("kami="..卡密.."&markcode="..imei.."&t="..Time.."&"..YiXiAPPKEY))--合成的签名
    local YiXiData=jzzh(RC4("kami="..卡密.."&markcode="..imei.."&t="..Time.."&sign="..YiXiSign.."&value="..value,YiXiRC4KEY),"加")
    Http.get(YiXiURL.."/api.php?api=kmlogon&app="..YiXiAPPID.."&data="..YiXiData,function(a,用户数据)
      用户数据=RC4(jzzh(用户数据),YiXiRC4KEY)

      登录验证=用户数据:match('"code":(.-),"')
      卡密ID=用户数据:match('"kami":"(.-)",')
      到期时间=用户数据:match('"vip":"(.-)"},')
      返回时间=用户数据:match('"time":(.-),"')
      返回信息=用户数据:match('"msg":"(.-)",')
      识别码=用户数据:match('"check":"(.-)"}')

      --j=用户数据:match("计算数:(.-);")
      if 登录验证=="200" then
        local id=卡密ID
        local YiXicheck=tostring(zxdbxwbzn(返回时间..YiXiAPPKEY..value))
        if (返回时间-Time)>15 or (返回时间-Time)<-15 then
          tw("检测到非法操作，请立即终止！","icon/a.png",0x60000000)
         else
          if tostring(YiXicheck)==tostring(识别码) then
            if 到期时间==nil then
              tw("检测到非法操作，请立即终止！","icon/a.png",0x60000000)
             else
              io.open(卡密存放路径,"w"):write(原卡密):close()
              到期日期=os.date("%Y-%m-%d %H:%M", 到期时间)
              tw("到期时间:"..到期日期,"icon/a.png",0x60000000)
              检测到期(到期时间)--这是循环检测卡密有没有到期
              --渐变跳转页面("mian",nil)
              进入页面()
              --activity.finish()
            end
           else
            tw("检测到非法操作，请立即终止！","icon/a.png",0x60000000)
          end
        end
       else
        --登录失败直接提示返回值(服务器自动返回错误信息)
        提示(返回信息)
      end
    end)
  end
end


-----------------------------强制更新
Http.get(YiXiURL.."/api.php?api=ini&app="..YiXiAPPID,function(a,用户数据)
  用户数据=RC4(jzzh(用户数据),YiXiRC4KEY)
  版本=用户数据:match('"version":"(.-)"')
  大小=用户数据:match('"version_info":"(.-)"')--大小
  强制更新=用户数据:match('"app_update_must":"(.-)"')--强制更新
  更新内容=用户数据:match('"app_update_show":"(.-)"')--内容
  下载地址=用户数据:match('"app_update_url":"(.-)"')--链接
  if 版本>Ver then--这个为版本判断跳出弹窗，自己修改
    弹窗()
   else if
      强制更新=="y" then
      弹窗()
     else
      tw("已是最新版本,无需更新","icon/a.png",0x60000000)
    end
  end
end)


function 弹窗()
  更新弹窗={
    LinearLayout;
    layout_height="fill";
    gravity="bottom";
    layout_width="fill";
    {
      CardView;
      layout_height="320dp";
      radius="50";
      elevation="1";
      layout_marginRight="20dp";
      layout_marginLeft="20dp";
      backgroundColor="#f4f7f7";
      layout_marginBottom="20dp";
      layout_width="match_parent";
      {
        LinearLayout;
        layout_height="80dp";
        gravity="center";
        backgroundColor="0x28FFFFFF";
        layout_width="match_parent";
        {
          LinearLayout;
          layout_gravity="center";
          orientation="vertical";
          {
            TextView;
            textSize="18sp";
            textColor="#000000";
            text="发现新版本";
            layout_gravity="center";
          };
          {
            TextView;
            text="V "..版本.."   |   "..大小;
            textSize="12sp";
          };
        };
      };
      {
        LinearLayout;
        layout_height="0.6dp";
        backgroundColor="#E0E3DA";
        layout_marginTop="80dp";
        layout_width="match_parent";
      };
      {
        LinearLayout;
        layout_height="190dp";
        orientation="vertical";
        backgroundColor="0x28FFFFFF";
        layout_marginTop="81dp";
        layout_width="match_parent";
        {
          TextView;
          text="最新版本V"..版本;
          textSize="13sp";
          layout_marginTop="5dp";
          layout_marginLeft="20dp";
        };
        {
          TextView;
          text=更新内容;
          textSize="13sp";
          layout_marginTop="20dp";
          layout_marginLeft="20dp";
        };
      };
      {
        LinearLayout;
        layout_height="match_parent";
        backgroundColor="#FFFFFFFF";
        gravity="center";
        layout_marginTop="271dp";
        layout_width="match_parent";
        {
          TextView;
          textSize="17sp";
          textColor="#000000";
          text="忽略本次";
          onClick="忽略";
          layout_marginRight="40dp";
        };
        {
          LinearLayout;
          layout_height="20dp";
          backgroundColor="#000000";
          layout_width="1";
        };
        {
          TextView;
          textSize="17sp";
          textColor="#000000";
          text="立即更新";
          onClick="更新";
          id="文字";
          layout_marginLeft="40dp";
        };
      };
    };
  };
  dialog= AlertDialog.Builder(this)
  import "android.text.Spannable"
  import "android.text.SpannableString"
  import "android.text.style.ForegroundColorSpan"
  dialog1=dialog.show()
  dialog1.getWindow().setContentView(loadlayout(更新弹窗));
  dialog1.setCanceledOnTouchOutside(false)
  dialog1.setCancelable(false)
  import "android.graphics.drawable.ColorDrawable"
  dialog1.getWindow().setBackgroundDrawable(ColorDrawable(0x00000000));
  function down(url,path)
    local tt=Ticker()
    tt.start()
    Http.download(url,path,function(code,data,cookie,header)
      tt.stop()
      文字.Text="更新完成"
      tw("下载完成","icon/a.png",0x60000000)
      activity.installApk("/storage/emulated/0/更新包.apk")
    end)
    function tt.onTick()
      local f=io.open(path,"r")
      if f~=nil then
        local len=f:read("a")
        local s=#len/lens
      end
    end
  end

  function big(url,path)
    import "java.net.URL"
    realUrl = URL(url)
    con = realUrl.openConnection();
    con.setRequestProperty("accept", "*/*");
    con.setRequestProperty("connection", "Keep-Alive");
    con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    lens=con.getContentLength()
    down(url,path)
  end

  function 更新()
    文字.Text="正在更新"
    tw("请保持网络畅通","icon/a.png",0x60000000)
    local url=""..下载地址..""
    local path="/storage/emulated/0/更新包.apk"--下载到xx路径
    big(url,path)
  end

  function 忽略()
    if 强制更新=="y" then
      tw("已开启强制更新，无法关闭","icon/a.png",0x60000000)
     else
      dialog1.dismiss()
      tw("请及时更新软件！","icon/a.png",0x60000000)
    end
  end

end
------------------------
function 解绑卡密.onClick()
  --可以来个弹窗提示说解绑一次扣除多少时间提醒
  local 卡密=k.text
  if 卡密=="" then
    tw("请输入卡密！","icon/a.png",0x60000000)
   else
    解绑卡密.text="正在解绑..."
    Time=os.time()
    local value=math.random(1000,99999)..os.time()
    local YiXiSign=tostring(zxdbxwbzn("kami="..卡密.."&markcode="..imei.."&t="..Time.."&"..YiXiAPPKEY))
    local YiXiData=jzzh(RC4("kami="..卡密.."&markcode="..imei.."&t="..Time.."&sign="..YiXiSign,YiXiRC4KEY),"加")
    Http.get(YiXiURL.."/api.php?api=kmunmachine&app="..YiXiAPPID.."&data="..YiXiData,function(a,用户数据)
      用户数据=RC4(jzzh(用户数据),YiXiRC4KEY)
      解绑状态=用户数据:match('"code":(.-),"')
      解绑信息=用户数据:match('"msg":"(.-)",')
      解绑卡密.text="解绑卡密"
      if 解绑状态=="200" then
        tw("设备解绑成功","icon/a.png",0x60000000)
       else
        提示(解绑信息)
      end

    end)
  end
end

卡密查询.onClick=function()

  url=YiXiURL..'/km.php'
  viewIntent = Intent("android.intent.action.VIEW",Uri.parse(url))
  activity.startActivity(viewIntent)

end
k.setInputType(129)--不显示卡密


function 检测到期(到期时间)
  --这里是检测卡密到期时间
  ti=Ticker()
  ti.Period=1000
  ti.onTick=function()
    if 到期日期<os.date("%Y-%m-%d %H:%M") then
      tw("您的卡密已过期！","icon/hello.png",0x60000000)
      os.exit()
      --到期退出程序
    end
  end
  ti.start()

end

Time=os.time()
Http.get(YiXiURL.."/api.php?api=notice&app="..YiXiAPPID,function(a,用户数据)
  if 用户数据:match("<title>(.-)</title>")=="检测中" then
    tw("当前请求状态异常，将自动为您跳转验证","icon/qq.png",0x60000000)
    task(3000,function()
      url=YiXiURL
      viewIntent = Intent("android.intent.action.VIEW",Uri.parse(url))
      activity.startActivity(viewIntent)
    end)
  end
  用户数据=RC4(jzzh(用户数据),YiXiRC4KEY)
  公告状态=用户数据:match('"code":(.-),"')
  if 公告状态=="102" then
    tw("软件已关闭","icon/d.png",0x60000000)
    task(3000,function()
      os.exit()
    end)
  end
  if 公告状态=="200" then
    公告内容=用户数据:match('"app_gg":"(.-)"')
    tw("服务器链接正常","icon/hello.png",0x60000000)
    if 公告内容 ~= "" then
      弹出信息("公告",公告内容,"确定")
    end
   else
    tw("服务器链接异常","icon/qq.png",0x60000000)
    os.exit()
  end
end)

function 进入页面()
tw("登录成功","icon/hello.png",0x60000000)
--content
--需要运行的程序
end
---[=[  ｸﾞｯ!(๑•̀ㅂ•́)و✧ ]=]---



jiaqun.onClick = function()
  加QQ群(aaqun)
end

-------------------------------------